## DHCP: Automation, Attacks, and Protection

---

### The Role of DHCP

- **Purpose**
    - Automates IP address assignment for network devices.
    - Reduces administrative workload and speeds up client provisioning.
- **Additional Capabilities**
    - Can provide other settings, such as default gateway and DNS server addresses.

---

### DHCP Vulnerabilities and Attacks

#### 1. DHCP Spoofing Attack

- **How it works**
    - An attacker runs a rogue DHCP server.
    - Responds to clients’ DHCP requests faster than the legitimate server.
    - Provides incorrect IP settings (e.g., attacker’s IP as gateway or DNS).
    - Can cause denial of service, man-in-the-middle, or data interception.

#### 2. DHCP Starvation Attack

- **How it works**
    - Attacker floods the DHCP server with requests using spoofed MAC addresses.
    - Exhausts the DHCP address pool, making legitimate clients unable to obtain IP addresses.
    - Often used to force clients to use a rogue DHCP server.

---

### Mitigation Techniques

#### 1. Port Security

- **Limits the number of MAC addresses per switch port.**
    - Prevents a single port from being used to launch a DHCP starvation attack.
    - Set the MAC address limit to a value that covers legitimate devices only.

#### 2. DHCP Snooping

- **Layer 2 security feature that protects against DHCP attacks.**
- **How it works:**
    - Classifies switch ports as trusted (can send DHCP server responses) or untrusted (should only send client requests).
    - Only ports connected to legitimate DHCP servers are trusted.
    - All other ports (typically user access ports) are untrusted by default.
    - Filters DHCP messages and maintains a DHCP snooping binding table with client MAC, IP, VLAN, and port information.
    - Drops unauthorized DHCP server responses on untrusted ports.
- **Mitigates both spoofing and starvation to some degree.**

#### 3. Rate Limiting (Optional)

- **Limits the number of DHCP packets per second on untrusted ports.**
    - Helps prevent flooding attacks.

---

### DHCP Snooping Configuration Steps (Example)

1. **Enable DHCP snooping globally and for specific VLAN(s):**
    - `ip dhcp snooping`
    - `ip dhcp snooping vlan 100`
2. **Configure persistent database location:**
    - `ip dhcp snooping database flash:/dhcp-snooping.db`
3. **Trust interfaces connected to DHCP servers or trunk links:**
    - `interface range FastEthernet 0/1 - 2`
    - `ip dhcp snooping trust`
4. **Apply rate limiting and port security on access ports:**
    - `interface range FastEthernet 0/3 - 24`
    - `ip dhcp snooping limit rate 5`
    - `switchport port-security`
    - `switchport port-security maximum 10`

---

### Verification Commands

- **Check DHCP Snooping Binding Table:**
    - `show ip dhcp snooping binding`
- **Check General DHCP Snooping Configuration:**
    - `show ip dhcp snooping`

---

### Key Points

- **DHCP simplifies IP address management but is vulnerable to spoofing and starvation attacks.**
- **Port security and DHCP snooping are essential for protecting the network from rogue DHCP servers and address pool exhaustion.**
- **Configure access/user ports as untrusted and only trust ports that connect to legitimate DHCP servers.**
- **Use port security and rate limiting to further protect against DHCP starvation.**